<stata>
run init.do
use ootmp,replace
keep if sessiontype==1 & !second & Period>9
egen myid=fill(1 1 1 1 1 1 2 2 2 2 2 2)
list in 1/10

* normalize bids
replace bid=bid-50
replace value=value-50
* run individual regressions
forvalues i=1(1)86 {
    * run regression
    quietly: reg bid value if myid==`i', noheader
    * store results of regression appropriately
    matrix define b=e(b)
    matrix define V=e(V)
    local explvars:colfullnames b
    local j=0
    * store coefficient estimates
    foreach var in `explvars' {
        local j=`j'+1
        capture replace b_`var'=b[1,`j'] if myid==`i'
        if _rc!=0 {
                quietly: gen b_`var'=.
            quietly: replace b_`var'=b[1,`j'] if myid==`i'
                }
    }
    * calculate and store two-tailed p values of coefficients
    local j=0
    foreach var in `explvars' {
        local j=`j'+1
        local t=b[1,`j']/V[`j',`j']^0.5
        local t=abs(`t')
        local p=2*ttail(e(df_r),`t')
        capture replace p_`var'=`p' if myid==`i'
        if _rc!=0 {
                quietly: gen p_`var'=.
            quietly: replace p_`var'=`p' if myid==`i'
                }
    }
}
collapse b_* p_* , by(sid)
gen r=1/b_value-1
* Following Isaac and James (2000) we confine attention to
* that individuals that have an insignifcant intercept (p<0.05)
drop if p__cons<0.05
* We also exclude those individuals that have an slope>=1 (ie. r<=0 and extreme r>10)
drop if r<=0
drop if r>10 // 1 observation is extreme outlier
* The variable r summarizes the individual CRRA parameter in u(x)=x^r
summ r
* --------------------
use ootmp,replace
replace oo=0 if oo==.
gen w=oo
gen eqbid=25+v/2 if sessiontype==1
replace eqbid=25+v/2-oo if sessiontype==2
gen x=(v-oo)
replace eqbid=2*x/3 if sessiontype==3 & x<=50
replace eqbid=(100*x*x-2*x*x*x/3-250000/3)/(200*x-x*x-5000) if sessiontype==3 & x>50
replace eqbid=x if second
gen eqbidA=eqbid           *(sessiontype==1)
gen eqbidB=eqbid           *(sessiontype==2)
gen eqbidC=eqbid           *(sessiontype==3)
gen eqbidC23=2*x/3         *(sessiontype==3)
gen Delta=(eqbid-eqbidC23) *(sessiontype==3)
bysort sessiontype second:sum eqbid*
bysort sessiontype second:sum Delta
save ootmp2,replace
capture program drop mytest
program define mytest
   estout ,cells("b(fmt(%9.3f)) se(fmt(%9.3f))") style(tex)
   foreach test in `*' {
      qui test `test'
      display "& " %9.3f r(p) "& "
   }
end
*
* Table 3: estimation of equation 11 for the A1 and B1 treatment:
*
use ootmp2,clear
gen const=1
qui reg bid const v    if sessiontype==1 & !second ,cluster(indepobs) noconst
mytest const=25 v=.5
qui reg bid const v w if sessiontype==2 & !second ,cluster(indepobs) noconst
mytest const=25 v=.5 w=-1
qui reg bid const v w if sessiontype<3  & !second ,cluster(indepobs) noconst
mytest const=25 v==.5 w=-1
*
* Table 4: estimation of equation 12 for the C1 treatment:
*
qui reg bid v w Delta const if sessiontype==3 & !second,cluster(indepobs) noconst
mytest v=2/3 w=-2/3 Delta=1 const=0
*
* Table 5, Second price overbidding, equation 15
*
qui reg bid v    if sessiontype==1 & second,cluster(indepobs) noconst
qui reg bid const v w if sessiontype==3 & second,cluster(indepobs) noheader  noconst
*
* Table 6, first price overbidding depending on the out side option, estimating equation 14:
*
reg bid const eqbidA eqbidB eqbidC23 Delta if !second,cluster(indepobs) noconstant
*
* Table 7: second price overbidding depending on the outside option, estimating equation 15:
*
qui reg bid const eqbidA eqbidC if second,cluster(indepobs) noconstant
mytest eqbidA=1 eqbidC=1

reg bid v oo Delta if sessiontype==3 & !second,cluster(indepobs)
reg bid v oo if sessiontype==3 & second,cluster(indepobs)
reg bid  eqbid1 eqbid2 eqbid3  Delta3 if !second,noconstant cluster(indepobs)
test eqbid1 = eqbid2
test eqbid2 = eqbid3
test Delta3 = 1
reg bid  eqbid1 eqbid3  if second,noconstant cluster(indepobs)
test eqbid3=eqbid1
test A1-A2 = C1-C2
texlist date st type sf kurs sid

</stata>
* --------------------------------------------------------------------------------
<R>
library(nlme)
library(foreign)
library(car)
#
# the following file is generated by stata above:
#
ootmp2 = read.dta("ootmp2.dta")
A1 = subset(ootmp2,data=ootmp2,sessiontype=="A no outside option" & !second & Period>9)
A1$v = A1$v-50
A1$bid = A1$bid-50

risk = by(A1,A1$sid,function(x) {
  model = lm(bid ~ v,data=x)
  c(unlist(linear.hypothesis(model,"(Intercept)=0")["Pr(>F)"])[2],coef(model)["v"],indepobs=median(x$indepobs))
})
risk2=as.data.frame(t(matrix(unlist(risk),nrow=3)))
colnames(risk2)=c("P","v","indepobs")

risk2$r = 1/risk2$v -1
summary(risk2$P)
okbid = risk2$P>.05 & risk2$r>0 & risk2$r<10
summary(okbid)
summary(risk2$r[okbid])

risk0 = by(A1,A1$sid,function(x) {
  model = lm(bid ~ v + 0,data=x)
  c(coef(model)["v"],indepobs=median(x$indepobs))
})
risk0[1:10]
risk02=as.data.frame(t(matrix(unlist(risk0),nrow=2)))
colnames(risk02)=c("v","indepobs")
risk02[1:10,]

risk02$r = 1/risk02$v -1
okbid = risk02$r>0 & risk02$r<10
summary(okbid)
summary(risk02$r[okbid])

summary(risk2$v)

attach(ootmp2)
A1 = subset(ootmp2,sessiontype=="A no outside option" & !second)
B1 = subset(ootmp2,sessiontype=="B opp. has equal oo" & !second)
AB1 = subset(ootmp2,sessiontype!="C opp. has random oo" & !second)
ABC1 = subset(ootmp2,!second)
C1 = subset(ootmp2,sessiontype=="C opp. has random oo" & !second)
A2 = subset(ootmp2,sessiontype=="A no outside option" & second)
C2 = subset(ootmp2,sessiontype=="C opp. has random oo" & second)
AC2 = subset(ootmp2,second==1)
detach(ootmp2)

A1.lm = lm(bid ~ v,data=A1)
linear.hypothesis(A1.lm,"v=.5")
A1.lme=lme(bid ~ v,random = ~ 1 | indepobs,data=A1)
lmr=function(model,random,data,equil,smallMix=T) {
  pv = function(coef,stdev,rand=NA,df) {
    coef["Residual"]=NA
    stdev["Residual"]=NA
    out = as.data.frame(cbind(round(coef,4),round(stdev,3)))
    if (length(rand)>1) {
      resx=coef
      is.na(resx)=c(1:length(resx))
      for (name in names(rand)) {
        resx[name]=as.numeric(rand[name])
      }
      out = cbind(out,round(resx[rownames(out)],3))
    }
    out = cbind(out,sprintf("%5.4f",2*pt(-abs((coef-equil)/stdev),df=df)))
    if (length(rand)>1) {
      colnames(out)=c("beta","stdev","sdrand","pvalue")
    } else {
      colnames(out)=c("beta","stdev","pvalue")
    }
    out
  }
  equil["Residual"]=NA
  tab2 = cbind(round(equil,4))
  colnames(tab2)="equil"
  # determine Wilcoxon P-values
  qq=sapply(by(data,list(data$indepobs),function(x) {lm (model,data=x)}),coef)
  Pw=equil  # give Pw some dimension (values are irrelevant)

  for (i in 1:(length(Pw)-1)) {
     Pw[i]=wilcox.test(qq[i,],mu=equil[i])$p.value/2
  }
  tab2 = cbind(tab2,round(Pw,4))
  #
  est.lm=lm(model,data=data)
  coef.lm=coef(est.lm)
  stdev.lm= sqrt(diag(hccm(est.lm)))
  sum.lm = summary(est.lm)
  r2.lm = sum.lm$r.squared
  tab2 = cbind(tab2,pv(coef.lm,stdev.lm,NA,est.lm$df.residual))
  #
  AIC.lme1 = NA
  if (smallMix) {
    est.lme1=lme(model,random = ~ 1 | indepobs,data=data)
    coef.lme1=fixed.effects(est.lme1)
    stdev.lme1=sqrt(diag(est.lme1$varFix))
    sum.lme1 = summary(est.lme1)
    AIC.lme1 = sum.lme1$AIC
    tab2 = cbind(tab2,pv(coef.lme1,stdev.lme1,VarCorr(est.lme1)[,"StdDev"],est.lme1$fixDF$X))
  }
  #
  est.lme2=lme(model,random=random,data=data)
  coef.lme2=fixed.effects(est.lme2)
  stdev.lme2=sqrt(diag(est.lme2$varFix))
  sum.lme2 = summary(est.lme2)
  AIC.lme2 = sum.lme2$AIC
  tab2 =cbind(tab2,pv(coef.lme2,stdev.lme2,VarCorr(est.lme2)[,"StdDev"],est.lme2$fixDF$X))
  #
  if (tex) {
    out=as.data.frame(c(names(coef.lm),"\\Residual"))
    out = cbind(out,tab2)
    apply(out,1,function(x) { cat(x,sep="&");cat("\\\\\n");})
    cat(sprintf("\\MM{%5.4f}{%5.4f}{%5.4f}\n",r2.lm,AIC.lme1,AIC.lme2))
  } else print(tab2)
}
options(error=recover)
tex=T
#
# Table 3: estimation of equation 11 for the A1 and B1 treatment:
#
A1.lmr = lmr(bid ~ v,             random = ~ 1 + v            | indepobs,data=A1, equil=c(25,.5))
B1.lmr = lmr(bid ~ v + w,         random = ~ 1 + v + w        | indepobs,data=B1, equil=c(25,.5,-1))
AB1.lmr= lmr(bid ~ v + w,         random = ~ 1 + v + w        | indepobs,data=AB1,equil=c(25,.5,-1))
#
# Table 4: estimation of equation 12 for the C1 treatment:
#
C1.lmr = lmr(bid ~ v + w + Delta, random = ~ 1 + v + w + Delta| indepobs,data=C1, equil=c(0,2/3,-2/3,1))
#
# Table 5, Second price overbidding, equation 15
#
A2.lmr = lmr(bid ~ v,             random = ~ 1 + v            | indepobs,data=A2, equil=c(0,1))
C2.lmr = lmr(bid ~ v + w,         random = ~ 1 + v + w        | indepobs,data=C2, equil=c(0,1,-1))
#
# Table 6, first price overbidding depending on the out side option, estimating equation 14:
#
# (note that the following two equations are without intercept, thus the first mixed effect estimation
# (which does contain an intercept by definition) does not report all standard deviations)
over1 = lmr( bid ~ eqbidA + eqbidB + eqbidC23 + Delta - 1,random = ~ eqbidA + eqbidB + eqbidC23 | indepobs,data=ABC1, equil=c(1,1,1,1),smallMix=F)
#
# Table 7: second price overbidding depending on the outside option, estimating equation 15:
over2 = lmr ( bid ~ eqbidA + eqbidC - 1, random = ~ eqbidA + eqbidC | indepobs, data=AC2, equil=c(1,1),smallMix=F)

A1.lmr = lmr(bid ~ v, random = ~ 1 + v | indepobs,data=A1,equil=c(25,.5))
B1.lmr = lmr(bid ~ v + w,random = ~ 1 + v + w | indepobs,data=B1, equil=c(25,.5,-1))

C1.lmr = lmr(bid ~ v + w + Delta, random = ~ 1 + v + w + Delta| indepobs,data=C1, equil=c(0,2/3,-2/3,1))
A2.lmr = lmr(bid ~ v,             random = ~ 1 + v            | indepobs,data=A2, equil=c(0,1))
C2.lmr = lmr(bid ~ v + w,         random = ~ 1 + v + w        | indepobs,data=C2, equil=c(0,1,-1))

over1 = lmr( bid ~ eqbidA + eqbidB + eqbidC23 + Delta - 1,random = ~ eqbidA + eqbidB + eqbidC23 | indepobs,data=ABC1, equil=c(1,1,1,1),smallMix=F)

over2 = lmr ( bid ~ eqbidA + eqbidC - 1, random = ~  eqbidA + eqbidC | indepobs, data=AC2, equil=c(1,1),smallMix=F)

</R>

