source("init.R")
source("zTree.R")
files=system("ls 08*/*.xls | cat",intern=TRUE)
ic1=zTreeTables(files,tables=c("globals","subjects"))
icKlick=zTreeTables(files,tables=c("Klicks"))
icSess <- zTreeTables(files,tables=c("session"))
#
ic1=merge(ic1$globals,ic1$subjects)
ic1=subset(ic1,Treatment==2)
ic1$indepobs=as.factor(with(ic1,paste(Date,Group,sep="_")))
ic1$subjectid=as.factor(with(ic1,paste(Date,Subject,sep="_")))
params = with(ic1,aggregate(defaultpi,list(Pifair=pilow,Piunfair=pihigh,S=S,alpha=alpha,beta=beta),mean))
payA.fair=NULL
payA.unfair=NULL
payA.fair.vec=NULL
payA.unfair.vec=NULL
for (i in as.numeric(rownames(params))) {
  payA.fair[[i]]  = payA(Pi=params[i,"Pifair"],S=params[i,"S"],alpha=params[i,"alpha"],beta=params[i,"alpha"])
  payA.unfair[[i]]= payA(Pi=params[i,"Piunfair"],S=params[i,"S"],alpha=params[i,"alpha"],beta=params[i,"alpha"])
  payA.fair.vec[[i]]  = cbind(as.vector(payA.unfair[[i]]$pay[,,"A"]),as.vector(payA.unfair[[i]]$pay[,,"B"]))
  payA.fair.vec[[i]]  = cbind(as.vector(payA.fair[[i]]$pay[,,"A"]),as.vector(payA.fair[[i]]$pay[,,"B"]))
}
params=cbind(params,t(sapply(as.numeric(rownames(params)),function(i) c(50*payA.fair[[i]]$eq$strat[,2],payA.fair[[i]]$eq$pay[,2],50*payA.unfair[[i]]$eq$strat[,2],payA.unfair[[i]]$eq$pay[,2]))))
params$x=NULL
fairgain = sapply(1:length(rownames(params)), function(i) min(payA.fair[[i]]$eq$pay[,2] - payA.unfair[[i]]$eq$pay[,2]))
params = cbind(params,fairgain)
expensive = which(params$fairgain<0)[1]
inexpensive = which(params$fairgain>0)[1]
rownames(params)[expensive]="exp. fair."
rownames(params)[inexpensive]="inexp. fair."
ic1$indepobs=as.factor(gsub("_","-",ic1$indepobs))
ic1$wishPiVal = with(ic1,ifelse(wishedpi==1,pi1,ifelse(wishedpi==2,pi2,NA)))
ic1$fairpi = with(ic1,ifelse(abs(pi1-.5)<abs(pi2-.5),pi1,pi2))
ic1$expensive = ic1$S==params[expensive,"S"]
ic1$fair = zapsmall(ic1$usedpi-ic1$fairpi)==0
ic1$fairWish = zapsmall(ic1$wishPiVal-ic1$fairpi)==0
ic1$flex = with(ic1,Period>=ic1$PiChoiceStartsAt)
ic1$stage=with(ic1,ifelse(Period<Pi2StartsAt,1,ifelse(Period<PiChoiceStartsAt,2,3)))
ic1$sPeriod=with(ic1,ifelse(stage==1,Period,ifelse(stage==2,Period-Pi2StartsAt+1,Period-PiChoiceStartsAt+1)))
ic1$cPeriod=with(ic1,max(sPeriod)*(stage-1)+sPeriod)
BF = brFun(payA.fair[[expensive]],"A")
BF = merge(BF,brFun(payA.fair[[expensive]],"B"),all=TRUE)
BF = merge(BF,brFun(payA.fair[[inexpensive]],"A"),all=TRUE)
BF = merge(BF,brFun(payA.fair[[inexpensive]],"B"),all=TRUE)
bestR=NULL
for (exptype in c(expensive,inexpensive)) {
  for (ptype in c("A","B")) {
    bestR=rbind(bestR,brFun(payA.fair[[exptype]],ptype))
    bestR=rbind(bestR,brFun(payA.unfair[[exptype]],ptype))
  }
}
ic1 = merge(ic1,bestR,all.x=TRUE)
colnames(bestR)=c("guessedOtherChoiceA","bestReplyA","pi1","type")
ic1 = merge(ic1,bestR,all.x=TRUE)
colnames(bestR)=c("guessedOtherChoiceB","bestReplyB","pi2","type")
ic1 = merge(ic1,bestR,all.x=TRUE)
startFair=as.data.frame(with(subset(ic1,Period==1 & Subject==1),list(Date,usedpi==fairpi)))
colnames(startFair)=c("Date","startFair")
ic1 = merge(ic1,startFair,all.x=TRUE)
eNash = function(pay) {
  q1 = apply(pay$eq$strat,2,sum)
  effNash = as.data.frame(pay$eq$strat[,which(q1==max(q1))])
  colnames(effNash)="eNash"
  effNash$type=ifelse(rownames(effNash)=="A",1,2)
  effNash$usedpi=pay$par$Pi
  effNash
}
effNash=NULL
for (exp in c(expensive,inexpensive)) {
  effNash=rbind(effNash,eNash(payA.fair[[exp]]))
  effNash=rbind(effNash,eNash(payA.unfair[[exp]]))
}
# we have to swap own and other strategy here:
effNash0 <- within(effNash,type <- 3-type)
colnames(effNash)[1] <- "oNash"
effNash <- merge(effNash0,effNash)
effNash$oNash <- effNash$oNash + 1
effNash$eNash <- effNash$eNash + 1
ic1 <- merge(ic1,effNash,all.x=TRUE)
colnames(effNash)=c("type","pi1","eNashA","oNashA")
ic1 = merge(ic1,effNash,all.x=TRUE)
colnames(effNash)=c("type","pi2","eNashB","oNashB")
ic1 = merge(ic1,effNash,all.x=TRUE)
ic1F=ic1[ic1$flex,]
ic2F=ic1[ic1$flex,]
ic1F$guessedOtherChoice=ic1F$guessedOtherChoiceA
ic2F$guessedOtherChoice=ic2F$guessedOtherChoiceB
ic1F$eNash=ic1F$eNashA
ic2F$eNash=ic2F$eNashB
ic1F$oNash=ic1F$oNashA
ic2F$oNash=ic2F$oNashB
ic1F$bestReply=ic1F$bestReplyA
ic2F$bestReply=ic2F$bestReplyB
ic1F$ownChoice=ic1F$ownChoiceA
ic2F$ownChoice=ic2F$ownChoiceB
ic1F$usedpi=ic1F$pi1
ic2F$usedpi=ic2F$pi2
icF=rbind(ic1[!ic1$flex,],ic1F,ic2F)[,c("Date","Period","sPeriod","cPeriod","stage","subjectid","indepobs","fairpi","type","usedpi","ownChoice","otherChoice","eNash","oNash","guessedOtherChoice","bestReply","expensive","flex","startFair","fairWish","wishPiVal")]
#table(subset(icF, expensive)[,c("eNash","type")])
icF$fair = zapsmall(icF$usedpi-icF$fairpi)==0
icF<-within(icF, {
   over   <- ownChoice-eNash
   oover  <- otherChoice-oNash
   overBR <- ownChoice-bestReply
   BRnorm <- bestReply-eNash
   nExp   <- guessedOtherChoice-oNash
   BRnormU<- ifelse(fair,0,BRnorm)
   BRnormF<- ifelse(fair,BRnorm,0)
   eNashU <- ifelse(fair,0,eNash)
   eNashF <- ifelse(fair,eNash,0)
 })
save(ic1,icKlick,icF,BF,payA.fair,payA.unfair,payA.fair.vec,payA.unfair.vec,bestR,params,expensive,inexpensive,file="ic1.Rdata")
#
files=system("ls 08*/*.sbj | cat",intern=TRUE)
quest <- NULL
for(n in files) quest <- {
  xx<-as.data.frame(t(read.table(n, sep="\t", quote="",skip=1, colClasses = "character", fileEncoding="latin1")), allowEscapes=FALSE,stringsAsFactors = FALSE);
  names(xx)<-xx[1,]
  slines<-grep("strategy",xx[1,])
  xx<-xx[-1,]
  xx$comment<- if (length(slines)>1) apply(xx[,slines],1,function(x) paste(x,collapse=" ")) else xx[,slines]
  xx$file<-n
  if(is.null(quest)) xx else merge(quest,xx,all=TRUE)}
quest <- within(quest,{
  male <- factor(quest$male)
  levels(male)<-c("female","male")
  age<-as.numeric(age)
  complicated<-as.numeric(complicated)
})
save(quest,file="quest.Rdata")
