## ----options,include=FALSE,cache=FALSE-----------------------------------
opts_chunk[["set"]](fig.align='center', dev='tikz', external=TRUE, 
                    fig.width=5, fig.height=3, fig.show='hold', 
                    echo=FALSE,warning=FALSE, error=FALSE, message=FALSE, tidy=FALSE,
                    cache=TRUE,cache.comments=FALSE,autodep=TRUE,
                    par=TRUE, comment=NA, keep.blank.line=FALSE)
 knit_hooks[["set"]](par=function(before, options, envir){
 if (before) { options(max.print=40) ; options(width=80) }
 if (before && options[["fig.show"]]!='none') par(mar=c(4,4,0,.1),cex.main=1,font.main=1,cex.lab=.95,cex.axis=.9,mgp=c(2,.7,0),tcl=-.3)
 }, crop=hook_pdfcrop)
 
 #to avoid color problems
 knit_hooks$set(document = function(x) {sub('\\usepackage[]{color}', '\\usepackage{xcolor}', x, fixed = TRUE)})

## ----setup, include=FALSE, cache=FALSE-----------------------------------
library(plyr) 
library(parallel)
library(simpleboot)
library(stringr)
library(sm)
library(lavaan) #used for sem
##library(plotrix)
library(memisc)
library(Hmisc)
library(car)
library(lme4) 
library(plm)
library(reshape)
#library(ggplot2)
library(ks)
library(splines)
##library(semPlot)
##library(sjPlot)
##library(corrplot)
library(stargazer)
library(texreg)
##library(psychometric)
#library(modeest)
library(rjags)
library(runjags)
#
library(lattice)
library(latticeExtra)
library(scales)
##library(glmmADMB)## install as: install.packages("R2admb");install.packages("glmmADMB",repos=c("http://glmmadmb.r-forge.r-project.org/repos",getOption("repos")),type="source")
#
ltheme <- canonical.theme(color = FALSE)
ltheme$strip.background$col <- "transparent"
ltheme$par.main.text$font=1
ltheme$par.main.text$cex=1
ltheme$par.sub.text$font=1
ltheme$add.text$cex=.7
lattice.options(default.theme = ltheme)
#
mPal<-brewer.pal(6,"Greys")
mTheme<-custom.theme(fill = mPal)
mTheme$par.main.text$font=1
mTheme$par.main.text$cex=1
mTheme$par.sub.text$font=1
#
library(xtable)
options(xtable.floating=FALSE)
options(xtable.sanitize.text.function=function(x) x)
options(xtable.include.rownames=FALSE)
evalSlow=FALSE ## creates "dic.Rdata", "dic.Pun.Rdata", "jags2dfAll.Rdata"
#

## ----ReadingData,error=FALSE,include=FALSE,warning=FALSE-----------------
#setwd("C:/Users/bo67riq/Documents/Auction")
# --------------------------------------------------------------------------------#
# ---------------------- Reading the ztree Date into R ---------------------------#
# --------------------------------------------------------------------------------#
##source("http://www.kirchkamp.de/lab/zTree.R")
library(zTree) ## <- I finally made zTree a package [o.k.]
options(zTree.silent=TRUE) # <- less chatty
setwd("../Data/Daten")
allFiles<-list.files(".","*.xls",recursive=TRUE)
zTree       <- zTreeTables( allFiles )
subjects <- zTree$subjects
globals <- zTree$globals 
 
#um Subject files (also questionnaire zu buchen)
files <- list.files(pattern = "*.sbj$",recursive=TRUE)
fname <- sub(".*/","",files)
#sbj <- zTreeSbj(aggregate(files,list(fname),function(x) x[1])$x) 
sbj <- zTreeSbj(files)
setwd("../../Paper")
sbj<-sbj[order(sbj$Date,as.numeric(sbj$Subject)),]

## ----DataPreparation,error=FALSE,include=FALSE,warning=FALSE-------------
subjects<-within(subjects,{sid<-as.factor(paste(Date,Subject,sep="_"))})
sbj<-within(sbj,{sid<-as.factor(paste(Date,Subject,sep="_"))})
Nsubj<-nrow(sbj) #the amount of participated subjects
costs<-sum(subjects$Profit)
#recoding female and male into english
sbj<-within(sbj,{Geschlecht<-ifelse(Geschlecht=="Weiblich","Female","Male")})
sbj<-within(sbj,{Besten50<-ifelse(Besten50=="Ja",1,0)})
sbj$Alter<-as.numeric(as.character(sbj$Alter))
## @ Wladislaw: the following can be done more systematically
## sbj$Semester<-recode(sbj$Semester,"'1-2'=1;'3-4'=3;'5-6'=5;'7-8'=7;'9-10'=9;'11-12'=11;else=13")
sbj$Semester<-as.numeric(sub("-.*|>=","",sbj$Semester))
meanYear<-c("first","second","third","fourth","fifth","sixth","seventh")[floor(mean((sbj$Semester+1)/2))]
## @ Wladislaw: what is the purpose of the following, why don't you like storing dates as characters?
subjects$Date<-as.numeric(gsub("_","",subjects$Date)) #change data-string
globals$Date<-as.numeric(gsub("_","",globals$Date)) #change data-string
sbj$Date<-as.numeric(gsub("_","",sbj$Date))
subjects<-join(subjects,globals[,c("Date","Treatment.1")])
#
subjects<-within(subjects,{TreatN<-factor(Treatment.1);levels(TreatN)<-c("\\Base","\\CPun","\\UCPun")})
ColB<-grep("^b\\[[0-9]+\\]$",names(subjects),value=TRUE)
ColP<-grep("^p\\[[0-9]+\\]$",names(subjects),value=TRUE)
subjL<-within(reshape(subjects[,c("sid",ColB,ColP)],direction="long",timevar="avCont",idvar="sid",varying=c(ColB,ColP),sep="["),avCont<-as.numeric(sub("]","",avCont)))
subjL<-join(subjL,subjects[,c("sid","TreatN","u")])
subjL<-within(subjL,relAvCont<-avCont-u)
subjPun<-with(within(subset(subjL,TreatN!="Base"),TreatN<-factor(TreatN)),aggregate(p~relAvCont+TreatN,FUN=mean))
#
sub2cor <- function(minCont=0,maxCont=20,nn=c("r","p","b"),method="spearman") {
    xx<-subset(subjL,avCont>=minCont & avCont<=maxCont)
    xx<-data.frame(t(sapply(by(xx,list(xx$sid),function(x) {
        z<-with(x,cor.test(avCont,b,method=method));
        c(z$estimate,p=z$p.value,b=max(x$b))}),c)))
    names(xx)<-nn
    xx[["sid"]]<-rownames(xx)
    xx
}
# identify types:
c1<-sub2cor()
c2<-sub2cor(maxCont=10,nn=c("rL","pL","bL"))
c3<-sub2cor(minCont=10,nn=c("rH","pH","bH"))
cc<-join(join(c1,c2),c3)
cc<-within(cc,{
    TypeContr<-rep("other",length(p))
    TypeContr[rL>0 & rH<0]<-"humpShaped";
    TypeContr[r>0 & p<.01]<-"CondCoop";
    TypeContr[b==0]<-"FreeRider";
    TypeContr<-factor(TypeContr)
})
#
subjL<-join(subjL,cc[,c("sid","TypeContr")])
subjLMean<-with(subjL,aggregate(b~TypeContr+avCont+TreatN,FUN=mean))
subjLCount<-within(with(subset(subjL,avCont==0),aggregate(b~TypeContr+TreatN,FUN=length)),TypeContr<-reorder(TypeContr,b))
subjLCount<-within(join(subjLCount,with(subjLCount,aggregate(cbind(tot=b) ~ TreatN,FUN=sum))),rel<-b/tot)
subjLMeanClean<-within(subset(subjLMean,TypeContr %in% subset(subjLCount,b>1)$TypeContr),
                       TypeContr<-factor(TypeContr))

subjLPerc<- with(subjLCount,{
        z<-aggregate(b~TypeContr,FUN=sum)
        b<-round(100*z$b/sum(z$b));names(b)<-z$TypeContr
        b
    })

## ----DataPreparationForRegressions,error=FALSE,include=FALSE,warning=FALSE----
subjects<-merge(x=subjects,y=sbj, by='sid', all.y = TRUE)
#get the columns of b and p
ColB<-grep("^b\\[[0-9]+\\]$",names(subjects),value=TRUE)
ColP<-grep("^p\\[[0-9]+\\]$",names(subjects),value=TRUE)
ColsAdd<-grep("Date|Treatment.1|Subject|counter|beliefU|sid|Alter|Geschlecht|StudienSchwerpunkt|Semester|Besten50",names(subjects),value=TRUE)
ColsAdd<-unique(c(ColsAdd,"u"))
ColsAdd

##############
##
##Melting the data such that each choice is in each row -for the general data
##
##############
MeltFrame1 <- melt(subjects[c(ColsAdd,ColB)], id=ColsAdd)
MeltFrame2 <- melt(subjects[c(ColsAdd,ColP)], id=ColsAdd)

colnames(MeltFrame1) <- c(ColsAdd,"CondOn", "CondContr")
MeltFrame1$CondOn<-gsub("b|\\[|\\]","",MeltFrame1$CondOn)
colnames(MeltFrame2) <- c(ColsAdd,"CondOn", "CondPun")
MeltFrame2$CondOn<-gsub("p|\\[|\\]","",MeltFrame2$CondOn)

GameData<-join(x=MeltFrame1,y=MeltFrame2)

#just so it looks better:
subjects$Treat<-as.factor(subjects$Treatment.1)
cutFB <- function(x) cut(x,c(-20,-14,-8,-2,2,8,14,20),include.lowest=TRUE)
GameData<-within(GameData,{
    Treat            <-as.factor(Treatment.1)
    CondOn           <-as.numeric(CondOn)
    CondOnPunUncon   <- CondOn - u
    CondOnPunCon     <- CondOn - CondContr
    CondOnPunUnconClust<-cutFB(CondOnPunUncon)
    CondOnPunConClust<-cutFB(CondOnPunCon)
    CondContrmU      <-CondContr-u
    CondOnUncon      <-CondOn-u
    CondOnBelief     <-CondOn-beliefU
    CondOnUnconClust <- cutFB(CondOnUncon) ## this used to be CondOnPunUncon before, but I think this was a typo
})

## ----Regression1Data,include=FALSE---------------------------------------
Model_Cond2<-lmer(CondContr ~ Treat*CondOn+(1|sid),data=GameData)
Model_Cond2_2<-lmer(CondContr ~ Treat*CondOn+(1+CondOn|sid),data=GameData)
GameData$Treat<-relevel(as.factor(GameData$Treat), ref="2")
Model_CondPun3<-lmer(CondPun ~ Treat*CondOn+(1|sid),data=GameData[GameData$Treat!=1,])
Model_CondPun5_2<-lmer(CondPun ~ Treat*scale(CondOn)+scale(u)+scale(CondContr)+(1+scale(CondOn)|sid),data=GameData[GameData$Treat!=1,])
library(nnet)

## ----bayesFigCommon,cache=FALSE------------------------------------------
bTrans<-read.csv(text="
var,tex
beta[1],$\\beta^C$ (Intercept)
beta[2],$\\beta^C_{\\otherC}$
beta[3],$\\beta^C_{\\CPun}$
beta[4],$\\beta^C_{\\UCPun}$
beta[5],$\\beta^C_{\\otherC  \\times \\CPun}$
beta[6],$\\beta^C_{\\otherC  \\times \\UCPun}$
gamma[1],$\\gamma^C$ (Intercept)
gamma[2],$\\gamma^C_{\\CPun}$
gamma[3],$\\gamma^C_{\\UCPun}$
tau[1],$\\tau_C$
tau[2],$\\tau_{C\\ranI}$
tau[3],$\\tau_{C\\ranS}$")
##
bTrans.Pun<-read.csv(text="
var,tex
beta[1],$\\beta^P$ (Intercept)
beta[2],$\\beta^P_{\\otherC }$
beta[3],$\\beta^P_{\\UCPun}$
beta[4],$\\beta^P_{\\otherC  \\times \\UCPun}$
gamma[1],$\\gamma^P$ (Intercept)
gamma[2],$\\gamma^P_{\\UCPun}$
tau[1],$\\tau_{P}$
tau[2],$\\tau_{P\\ranI}$
tau[3],$\\tau_{P\\ranS}$")
##
mySegPlot <- function(df,xlab) {
    ## df<-df[grep("Intercept",df[["tex"]],invert=TRUE),]
    df<-within(df,{n<-1:length(tex);tex<-reorder(tex,-n)})
    p1<-segplot(tex~Lower95+Upper95,centers=Median,panel=function(...) {panel.abline(v=0);panel.refline(h=1:nrow(df));panel.segplot(...)},xlab=xlab,data=df,draw.bands=FALSE,segments.fun=panel.arrows,ends = "both",angle=90,length = 1, unit = "mm")
    oddmax<-exp(max(abs(log(df$odd)))*1.05)
    oddrange<-c(1/oddmax,oddmax)
    p2<-dotplot(tex ~odd ,data=df,panel=function(...) {panel.dotplot(...);panel.refline(v=seq(-5,5,2)/log(10));panel.abline(v=0)},xscale.components=xscale.components.log,xlab="$P(\\beta>0):P(\\beta\\le0)$",xlim=oddrange,scales=list(x=list(log=10),y=list(draw=FALSE)))
    plot(p1,position=c(0,0,.58,1),more=TRUE)
    plot(p2,position=c(.53,0,1,1))
}
##
cistr<-function(ba,var) paste("$[",paste(sprintf("%.2f",ba$summary$quantiles[var,c("2.5%","97.5%")]),collapse=", "),"]$\\footnote{Eff.~sample size=$",signif(ba$mcse$sseff[var],3),"$, psrf=$",sprintf("%.4f",ba$psrf$psrf[var,1],3),"$.}")
##
sum2odd<-function(sum,i,negative=FALSE,short=FALSE,evi=TRUE) {
    if(is.character(i)) {
        i <- grep(i,sum[["tex"]])
        if(length(i) != 1) stop("*** pattern does not match in sum2odd ***")
    }
    lx<-log(sum[i,"odd"])
    if(negative) lx<- -lx
    tex<-sum[i,"tex"]
    txt<-"no substantial";
    if(lx>1) txt<-"positive";
    if(lx>3) txt<-"strong";
    if(lx>5) txt<-"very strong";
    if(short) return(txt)
    odds<-paste("odds that ",tex,ifelse(negative,"{}$<0$","{}$>0$")," are ",odd2txt(exp(lx)),sep="")
    if(evi) odds<-paste(odds,", i.e., we have ",txt," evidence",sep="")
    odds
    }
##
odd2txt <- function(x,rel=FALSE) { 
    if(is.na(x)) return("")
    if(rel)
        x<-c(1-x,x)
    else
        x<-c(1,x)
    if(min(x)>0) x<-x/min(x)
    paste("$",signif(x[2],3),":",signif(x[1],3),"$")
    }
##
rel2txt <- function(x) 
    odd2txt(x,rel=TRUE)
##
jags2df <- function(x.jags,pattern="^beta",trans) {
    x.sum<-summary(x.jags)
    x.sum<-data.frame(x.sum[grep(pattern,rownames(x.sum)),])
    x.sum[["var"]]<-factor(rownames(x.sum))
    x.sum <- join(x.sum,trans,by="var")
    # now calculate the odds:
    x.mcmc<-data.frame(as.mcmc(x.jags))
    x.mcmc<-x.mcmc[,grep(pattern,names(x.mcmc))]
    x.o<-apply(x.mcmc>0,2,mean)
    x.o<-(x.o-1/2)*(nrow(x.mcmc)-1)/(nrow(x.mcmc)+1)+1/2 # conservative, reduce odds
    x.sum[["odd"]]<-x.o/(1-x.o)
    x.sum
}
##
sumTau <- function(xx,pattern="^tau",trans) {
    xx<-data.frame(xx)
    xx<-xx[grep(pattern,rownames(xx)),]
    xx[["var"]]<-rownames(xx)
    join(xx,trans,by="var")
}
##
#
sum2xtable2 <- function(xx) {
    xx[["odd"]]<-sapply(xx[["odd"]],odd2txt)
    xx<-xx[,c("tex","Median","Lower95","Upper95","odd","SSeff","psrf")]
    xx<-plyr::rename(xx,replace=c("Lower95"="$Q_{.025}$","Upper95"="$Q_{.975}$",
                                  "odd"="$o(>0)$","tex"=""))
    xtable(xx,digits=c(0,0,3,3,3,3,0,4))
}
#
mmodI<-function(par,ranSlope,hurdle) which(par["ranSlope",]==ranSlope & par["hurdle",]==hurdle)

## ----bayesInit,include=FALSE,cache=FALSE---------------------------------
jags.ver<-testjags()
NumberOfChains<-min(4,detectCores())
nBurnin<-4000
nSample<-10000
nAdapt<-1000
nThin<-10

demean <- function(X) {
    mean.X <- apply(X, 2, mean)
    var.X <- apply(X,2,var)
    mean.X[var.X==0]<-0 ## do not demean constant (this, actually, helps convergence)
    sweep(data.matrix(X),2,mean.X)
}

initJags <-function(chain) {
  chain<-as.numeric(chain)
  list(.RNG.seed=chain+27,.RNG.name=c("base::Mersenne-Twister","base::Super-Duper","base::Wichmann-Hill","lecuyer::RngStream")[chain %% 4 + 1])
}
#
genAllData<- function(data) list(within(data,{hurdle<-0;ranSlope<-0}),
              within(data,{hurdle<-0;ranSlope<-1}),
              within(data,{hurdle<-1;ranSlope<-0}),
              within(data,{hurdle<-1;ranSlope<-1}))

## ----bayesHurdleDef,include=FALSE----------------------------------------
## The following model does with and without random slopes, with and without a hurdle:
## 
simple.mod <-'model {
   for (i in 1:length(sid)) {
      #the function of the contribution/punishment
      Y[i]    ~ dnorm(meanY[i],tau[1])
      meanY[i] <- h[sid[i]]*(inprod(beta,X[i,])+ranSlope*uS[sid[i]]*X[i,2])+(1-h[sid[i]])*minY+uI[sid[i]]
   }
   # subject specific effects:
   for (s in 1:Nsubj) {
      h[s] ~ dbern(Prob[s])
      Prob[s] <- (1-hurdle) + hurdle * pnorm(inprod(gamma,sidTreat[s,]),0,1)
      uI[s] ~ dnorm(0,tau[2]) 
      uS[s] ~ dnorm(0,tau[3]) 
   }
   # Priors for parameters of four different models
   for (i in 1:nbeta) {beta[i] ~ dnorm(betaM[i],betaT[i])}  # contribution/punishment
   for (i in 1:ngamma) {gamma[i] ~ dnorm(gammaM[i],gammaT[i])} # latent hurdle, treatment specific
   for (i in 1:3) {
      m[i]     ~ dexp(1) # mean(tau)
      d[i]     ~ dexp(1) # SD(tau)
      tau[i]   ~ dgamma(m[i]^2/d[i]^2,m[i]/d[i]^2)
      sd[i]    <- sqrt(1/(tau[i]+10^-10))
   }
   hM<-mean(h)
}'
##
genCCData <- function(pseudo=c(2,2),pun=FALSE) { # in the pseudoprior case more data is generated for the richer model.
    ## (cc.mod), for simple.mod set pseudo<-NULL
    nbeta<-ifelse(pun,4,6)
    ngamma<-ifelse(pun,2,3)
    data<-subset(GameData,Treat!=1 | !pun)
    Nsubj<-length(unique(data$sid))
    Nobs<-nrow(data)
##
## we first do all models with vague priors:
    betaM<-array(0,c(nbeta,pseudo)); betaT<-array(.0001,c(nbeta,pseudo));
    gammaM<-array(0,c(ngamma,pseudo)); gammaT<-array(.0001,c(ngamma,pseudo));
    ##
    cc.data<-with(data,list(Nsubj=Nsubj,hurdle=0,ranSlope=0,
                             betaM=betaM,gammaM=gammaM,
                             betaT=betaT,gammaT=gammaT,
                             nbeta=nbeta,
                             ngamma=ngamma,
                             Y=if(pun) CondPun else CondContr,
                             sid=as.numeric(factor(sid)),
                             X=cbind(1,cbind(CondOn=CondOn,Treat==2,if(!pun) cbind(Treat==3,CondOn*(Treat==2)),CondOn*(Treat==3)))))
    #
    if(!is.null(pseudo)) {
        cc.data[["rP"]]<-1/2
        cc.data[["hP"]]<-1/2
        cc.data[["uIM"]]<-array(0,c(Nsubj,pseudo))
        cc.data[["uIT"]]<-array(-1,c(Nsubj,pseudo)) ## so far no pseudo priors
        cc.data[["uSM"]]<-array(0,c(Nsubj,pseudo))
        cc.data[["uST"]]<-array(-1,c(Nsubj,pseudo))
        cc.data[["uST"]][,1,] <- 1e8 ## ra=2 ??? random slope
    }
##
## add treatment data for hurdles:
    cc.data<-within(cc.data,{
        sidTreat<-as.matrix(cbind(1,aggregate(X[,3:(3+!pun)],list(sid),mean)[,2:(2+!pun)]))
        attr(X,"dimnames")<-NULL
        attr(sidTreat,"dimnames")<-NULL
    })
    cc.data
}
##
runjags.options(silent.jags=FALSE, silent.runjags=FALSE,force.summary=TRUE)
# c("h","uI","uS")
myRunJags<-function(data,burnin=nBurnin,sample=nSample,adapt=nAdapt,thin=nThin,model=simple.mod,method="parallel") {
    dd<-within(data,{X<-demean(X);minY<- -mean(Y);Y<-Y+minY})
    run.jags(model=model,data=dd,burnin = burnin, sample = sample, adapt = adapt, thin = thin, monitor=c("beta","gamma","hM","ranSlope","h","hurdle","tau"),method=method,inits=initJags,n.chains=NumberOfChains,modules="glm")
}
##
##
##
## to generate pseudopriors, we first call the model with known hurdle and ranSlope
##
## myRunJags(allData[[3]],burnin=100,adapt=100,sample=1000)

## ----bayesHurdle,eval=evalSlow,include=FALSE-----------------------------
cc.data<-genCCData(pseudo=NULL)
allData<-genAllData(cc.data)
## myRunJags(allData[[3]],burnin=100,adapt=100,sample=1000)
all.jags<-lapply(allData,myRunJags,model=simple.mod)
all.mcmc<-lapply(all.jags,as.mcmc)

model.par<-sapply(all.jags,function(jags) apply(as.mcmc(jags)[,c("ranSlope","hurdle")],2,mean))
extDic <- function (jags) c(extract(jags,c("sum.deviance")),
                            extract(jags,c("sum.pd")))
# all.dic<- sapply(all.jags,extDic)
save(all.jags,model.par,file="dic.Rdata")

## ----bayesHurdlePun,eval=evalSlow,include=FALSE--------------------------
## to generate pseudopriors, we first call the model with known hurdle and ranSlope
##myRunJags(allData[[3]])
cc.data.Pun<-genCCData(pseudo=NULL,pun=TRUE)
allData.Pun<-genAllData(cc.data.Pun)
## myRunJags(allData.Pun[[3]],burnin=100,adapt=100,sample=1000)
all.jags.Pun<-lapply(allData.Pun,myRunJags,model=simple.mod)
all.mcmc.Pun<-lapply(all.jags.Pun,as.mcmc)

model.par.Pun<-sapply(all.jags.Pun,function(jags) apply(as.mcmc(jags)[,c("ranSlope","hurdle")],2,mean))
extDic.Pun <- function (jags) c(extract(jags,c("sum.deviance")),
                                extract(jags,c("sum.pd")))
# all.dic.Pun<- sapply(all.jags.Pun,extDic.Pun)
save(all.jags.Pun,model.par.Pun,file="dic.Pun.Rdata")

## ----individual.hurdle,eval=evalSlow-------------------------------------
h2vec <- function(jags) {
    z<-summary(jags)
    z[grep("^h\\[",rownames(z)),"Mean"]
}
h.vec<-lapply(all.jags,h2vec)
h.vec.Pun<-lapply(all.jags.Pun,h2vec)

## ----CoefPlotHurdleWSlopePrep,eval=evalSlow,include=FALSE----------------
all.beta.df<-lapply(all.jags,jags2df,pattern="^beta",trans=bTrans)
all.gamma.df<-lapply(all.jags,jags2df,pattern="^gamma",trans=bTrans)
all.beta.df.Pun<-lapply(all.jags.Pun,jags2df,pattern="^beta",trans=bTrans.Pun)
all.gamma.df.Pun<-lapply(all.jags.Pun,jags2df,pattern="^gamma",trans=bTrans.Pun)
jags.sum<-lapply(all.jags,summary)
jags.Pun.sum<-lapply(all.jags.Pun,summary)
#
NumberOfChains<-length(all.jags[[1]][["mcmc"]])
samples<-all.jags[[1]][["sample"]]
burnin<-all.jags[[1]][["burnin"]]
#
odds<-list()
#odds[["T12Coop"]]<-mean((as.mcmc(all.jags[[3]])[,c("beta[3]","beta[5]")] %*% c(-1,-10.5))>0)
odds[["T32Coop"]]<-mean((as.mcmc(all.jags[[3]])[,c("beta[3]","beta[4]")] %*% c(-1,1))>0)
odds[["T32CoopGamma"]]<-mean((as.mcmc(all.jags[[3]])[,c("gamma[2]","gamma[3]")] %*% c(-1,1))>0)
#odds[["T23Pun"]]<-mean((as.mcmc(all.jags.Pun[[3]])[,c("beta[3]","beta[4]")] %*% c(-1,-10.5))>0)
#
save(allData,allData.Pun,samples,burnin,NumberOfChains,model.par,model.par.Pun,jags.sum,jags.Pun.sum,all.beta.df,all.gamma.df,all.beta.df.Pun,all.gamma.df.Pun,odds,h.vec,h.vec.Pun,file="jags2dfAll.Rdata")

## ----loadBayesSummaries,cache=FALSE--------------------------------------
load(file="jags2dfAll.Rdata")

## ----modI----------------------------------------------------------------
modI<-mmodI(model.par,ranSlope=0,hurdle=1)
modI.Pun<-mmodI(model.par.Pun,ranSlope=0,hurdle=1)

## ----classifyFrac.Bayes--------------------------------------------------
d2hTreat<- function(data,htype,comment,names=c("Base","CPun","UCPun")) {
    h.treat<-data.frame(data[[modI]][["sidTreat"]])
    names(h.treat)<-names
    within(h.treat,{
        if(! "CPun" %in% names) CPun<-1-UCPun
        treat<-ifelse(CPun,"\\CPun",ifelse(UCPun,"\\UCPun","\\Base"))
        h<-htype[[modI]]
        t<-comment
    })}
dfh2type<-function(d) {
    uncond<-mean(d[["h"]]==0)
    cond <-mean(d[["h"]]==1)
    other <- 1 - uncond - cond
    c(uncond=uncond,cond=cond,other=other)
}
##
df.h<-d2hTreat(allData,h.vec,"$\\text{Pr}(\\eye_{\\CC,i}=1)$")
df.h.Pun<-d2hTreat(allData.Pun,h.vec.Pun,"$\\text{Pr}(\\eye_{\\CP,i}=1)$",names=c("Base","UCPun"))
##
df.h.stats<-signif(dfh2type(df.h),3)*100
df.h.stats.Pun<-signif(dfh2type(df.h.Pun),3)*100

## ----Fischbacher_and_us,fig.width=6--------------------------------------
condID<-which(h.vec[[4]]==1 )
bwplot(CondContr ~ factor(CondOn)|condCoop,data=within(GameData,condCoop<-factor(!as.numeric(sid) %in% condID,label=c("classified as conditional cooperator","classified as free rider"))),horizontal=FALSE,xlab="Average contribution of other group members",ylab="\\begin{tabular}{c}Own conditional\\\\contribution\\end{tabular}")+layer(panel.refline(a=0,b=1))
#

## ----punishmentFig-------------------------------------------------------
##bwplot(p ~ factor(relAvCont) | factor(TreatN),data=subjL,subset=TreatN!="Base",horizontal=FALSE)
xyplot(p ~ relAvCont,group=TreatN,data=subjPun,type="l",ylab="Average punishment",xlab="Deviation from own unconditional contribution",auto.key=list(columns=3,points=FALSE,lines=TRUE))+layer(panel.refline(v=0))

## ----CoefPlotHurdleWSlopeMain1,fig.width=5,fig.height=2.1----------------
mySegPlot(all.beta.df[[modI]][-1,],xlab="$\\beta$")

## ----CoefPlotHurdleWSlopeMain2,fig.width=5,fig.height=1.6----------------
mySegPlot(all.gamma.df[[modI]],xlab="$\\gamma$")

## ----hurdlePlot,fig.width=5,fig.height=2.5-------------------------------
key<-list(columns=3)
with(rbind.fill(df.h,df.h.Pun),ecdfplot(~ h | t,group=treat,xlab="",auto.key=key))

## ----CoefPlotHurdleWSlopeMain1Pun,fig.width=5,fig.height=2.1-------------
modI<-mmodI(model.par.Pun,ranSlope=0,hurdle=1)
mySegPlot(all.beta.df.Pun[[modI]][-1,],xlab="$\\beta$")

## ----CoefPlotHurdleWSlopeMain2Pun,fig.width=5,fig.height=1.6-------------
mySegPlot(all.gamma.df.Pun[[modI]],xlab="$\\gamma$")

## ----logit2prob,include=FALSE--------------------------------------------
cc.ucpun<-signif(mean(subset(df.h,treat=="\\UCPun")[["h"]])*100,2)
cc.cpun<-signif(mean(subset(df.h,treat=="\\CPun")[["h"]])*100,2)
cc.base<-signif(mean(subset(df.h,treat=="\\Base")[["h"]])*100,2)
##
logit2prob <- function(logit){
  odds <- exp(logit)
  prob <- odds / (1 + odds)
  return(round(prob,2)*100)
}

## ----bayesTab01,results='asis'-------------------------------------------
modI<-mmodI(model.par,ranSlope=0,hurdle=1)
sum2xtable2(rbind.fill(all.beta.df[[modI]][-1,],all.gamma.df[[modI]],sumTau(jags.sum[modI],pattern="tau.[12]",trans=bTrans)))

## ----bayesTab00,results='asis'-------------------------------------------
modI<-mmodI(model.par,ranSlope=0,hurdle=0)
sum2xtable2(rbind.fill(all.beta.df[[modI]][-1,],sumTau(jags.sum[modI],pattern="tau.[1]",trans=bTrans)))

## ----bayesFig00,fig.height=2.1-------------------------------------------
mySegPlot(all.beta.df[[modI]][-1,],xlab="$\\beta$")

## ----bayesTab11,results='asis'-------------------------------------------
modI<-mmodI(model.par,ranSlope=1,hurdle=1)
sum2xtable2(rbind.fill(all.beta.df[[modI]][-1,],all.gamma.df[[modI]],sumTau(jags.sum[modI],trans=bTrans)))

## ----bayesFig11,fig.height=2.1-------------------------------------------
mySegPlot(all.beta.df[[modI]][-1,],xlab="$\\beta$")

## ----bayesFig11b,fig.height=1.7------------------------------------------
mySegPlot(all.gamma.df[[modI]],xlab="$\\gamma$")

## ----bayesTab.Pun01,results='asis'---------------------------------------
modI<-mmodI(model.par.Pun,ranSlope=0,hurdle=1)
sum2xtable2(rbind.fill(all.beta.df.Pun[[modI]][-1,],all.gamma.df.Pun[[modI]],sumTau(jags.Pun.sum[modI],pattern="tau.[12]",trans=bTrans.Pun)))

## ----bayesTab.Pun00,results='asis'---------------------------------------
modI<-mmodI(model.par.Pun,ranSlope=0,hurdle=0)
sum2xtable2(rbind.fill(all.beta.df.Pun[[modI]][-1,],sumTau(jags.Pun.sum[modI],pattern="tau.[12]",trans=bTrans.Pun)))

## ----bayesFig.Pun00,fig.height=2.1---------------------------------------
mySegPlot(all.beta.df.Pun[[modI]][-1,],xlab="$\\beta$")

## ----bayesTab.Pun11,results='asis'---------------------------------------
modI<-mmodI(model.par.Pun,ranSlope=1,hurdle=1)
sum2xtable2(rbind.fill(all.beta.df.Pun[[modI]][-1,],all.gamma.df.Pun[[modI]],sumTau(jags.Pun.sum[modI],trans=bTrans.Pun)))

## ----bayesFig.Pun11,fig.height=2.1---------------------------------------
mySegPlot(all.beta.df.Pun[[modI]][-1,],xlab="$\\beta$")

## ----bayesFig.Pun11b,fig.height=1.7--------------------------------------
mySegPlot(all.gamma.df.Pun[[modI]],xlab="$\\gamma$")

## ----RegressionMxdWoSlopeFreq,   results='asis', out.width="0.1\\linewidth"----
stargazer(Model_Cond2,#ci = TRUE,
          single.row = TRUE,#Model_Over4,#title="Regression for H1",
          dep.var.labels.include = FALSE,             style=  "aer",
          notes="$p: *** < .001 ** < .01 * < .05 $",notes.append=FALSE,star.cutoffs=c(.05,.01,.001),
          digits       = 2,
          digits.extra = 2,float=FALSE, ci = TRUE,         
          column.labels   = c("Frequentist Mixed Effects Model"),     
          covariate.labels = c("$\\beta^C$ (Intercept)","$\\beta^C_{\\otherC}$","$\\beta^C_{\\CPun}$",
                               "$\\beta^C_{\\UCPun}$","$\\beta^C_{\\otherC  \\times \\CPun}$","$\\beta^C_{\\otherC  \\times \\UCPun}$"),
          model.numbers          = FALSE, 
          order = c(1,4,2,3,5,6),
          intercept.bottom = FALSE
) 

## ----RegressionMxdWoSlopeFreqPun,   results='asis', out.width="0.1\\linewidth"----
stargazer(Model_CondPun3,#ci = TRUE,
          single.row = TRUE,#Model_Over4,#title="Regression for H1",
          dep.var.labels.include = FALSE,             style=  "aer",
          notes="$p: *** < .001 ** < .01 * < .05 $",notes.append=FALSE,star.cutoffs=c(.05,.01,.001),
          digits       = 2,
          digits.extra = 2,float=FALSE, ci = TRUE,         
          column.labels   = c("Frequentist Mixed Effects Model"),     
          covariate.labels = c("$\\beta^C$ (Intercept)","$\\beta^C_{\\otherC}$",
                               "$\\beta^C_{\\UCPun}$","$\\beta^C_{\\otherC  \\times \\UCPun}$"),
          model.numbers          = FALSE, 
          order = c(1,3,2,4),
          intercept.bottom = FALSE
) 

## ----theEnd--------------------------------------------------------------
##save.image(file="theEnd.Rdata")

